
-- Domain Takip Sistemi Veritabanı Şeması
-- Kullanım: MySQL/MariaDB

-- Admin kullanıcıları tablosu
CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_login TIMESTAMP NULL,
    is_active TINYINT(1) DEFAULT 1
);

-- Domainler tablosu
CREATE TABLE IF NOT EXISTS domains (
    id INT AUTO_INCREMENT PRIMARY KEY,
    domain_name VARCHAR(255) NOT NULL UNIQUE,
    registrar VARCHAR(255),
    registration_date DATE,
    expiration_date DATE,
    nameservers TEXT,
    status VARCHAR(50),
    auto_renew TINYINT(1) DEFAULT 0,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    last_checked TIMESTAMP NULL,
    days_until_expiry INT
);

-- Bildirim ayarları tablosu
CREATE TABLE IF NOT EXISTS notification_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email_notifications_enabled TINYINT(1) DEFAULT 1,
    notification_email VARCHAR(255) NOT NULL,
    warning_days INT DEFAULT 30,
    critical_days INT DEFAULT 7,
    dashboard_url VARCHAR(500),
    smtp_host VARCHAR(255) DEFAULT '',
    smtp_port INT DEFAULT 587,
    smtp_username VARCHAR(255) DEFAULT '',
    smtp_password VARCHAR(255) DEFAULT '',
    smtp_secure ENUM('tls','ssl','none') DEFAULT 'tls',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Bildirim logları tablosu
CREATE TABLE IF NOT EXISTS notification_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    domain_id INT NOT NULL,
    type ENUM('email', 'sms', 'webhook') DEFAULT 'email',
    event ENUM('expiry_warning', 'expiry_critical', 'expired') DEFAULT 'expiry_warning',
    status ENUM('sent', 'failed', 'pending') DEFAULT 'sent',
    message TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (domain_id) REFERENCES domains(id) ON DELETE CASCADE
);

-- Varsayılan admin kullanıcısı (şifre: admin123)
INSERT INTO admin_users (username, password, email) VALUES 
('admin', '$2y$12$qT1t7M9KS5Lcr/DpujQBbeDmVSiMVB8y5oNcQUK0FFO3bHWSbAfhu', 'admin@example.com')
ON DUPLICATE KEY UPDATE username = username;

-- Varsayılan bildirim ayarları
INSERT INTO notification_settings (notification_email, warning_days, critical_days, dashboard_url) VALUES 
('admin@example.com', 30, 7, 'http://localhost/domain-tracker/')
ON DUPLICATE KEY UPDATE id = id;


-- Domain durumları için indeks
-- Önce varsa sil, yoksa hata alma
SET @idx_exists := (SELECT COUNT(1) FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema = DATABASE() AND table_name = 'domains' AND index_name = 'idx_domain_status');
SET @sql := IF(@idx_exists > 0, 'DROP INDEX idx_domain_status ON domains', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
CREATE INDEX idx_domain_status ON domains(status);
CREATE INDEX idx_expiration_date ON domains(expiration_date);
CREATE INDEX idx_days_until_expiry ON domains(days_until_expiry);

-- Bildirim logları için indeks
CREATE INDEX idx_notification_domain_id ON notification_logs(domain_id);
CREATE INDEX idx_notification_created_at ON notification_logs(created_at);
CREATE INDEX idx_notification_type_event ON notification_logs(type, event);

