<?php
require_once 'config/config.php';
require_once 'includes/domain_functions.php';
requireLogin();
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['import_file'])) {
    $file = $_FILES['import_file']['tmp_name'];
    $ext = strtolower(pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION));
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $count = 0;
    foreach ($lines as $line) {
        if ($ext === 'csv') {
            $parts = str_getcsv($line);
            $domainName = $parts[0] ?? '';
        } else {
            $domainName = trim($line);
        }
        if ($domainName && filter_var($domainName, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME)) {
            $stmt = $pdo->prepare("SELECT id FROM domains WHERE domain_name = ?");
            $stmt->execute([$domainName]);
            if (!$stmt->fetch()) {
                $stmt = $pdo->prepare("INSERT INTO domains (domain_name, created_at) VALUES (?, NOW())");
                $stmt->execute([$domainName]);
                DomainInfo::updateDomainInfo($pdo, $pdo->lastInsertId());
                $count++;
            }
        }
    }
    $message = "$count domain başarıyla eklendi.";
    // Başarılı ekleme sonrası yönlendirme için flag
    $redirect = true;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Domain İçe Aktar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <div class="container mt-5">
        <h2>Domain İçe Aktar</h2>
        <?php if ($message): ?>
            <div class="alert alert-success"> <?= $message ?> </div>
            <?php if (isset($redirect) && $redirect): ?>
                <script>
                    setTimeout(function() {
                        window.location.href = 'dashboard.php';
                    }, 2000);
                </script>
            <?php endif; ?>
        <?php endif; ?>
        <form method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="import_file" class="form-label">Dosya Seç (.csv veya .txt)</label>
                <input type="file" class="form-control" id="import_file" name="import_file" accept=".csv,.txt" required>
            </div>
            <button type="submit" class="btn btn-primary">İçe Aktar</button>
        </form>
    </div>
</body>
</html>
