<?php
require_once 'config/config.php';
requireLogin();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF kontrolü
    if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $message = 'Güvenlik hatası: CSRF token geçersiz.';
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        $password2 = $_POST['password2'] ?? '';

        // Kullanıcı adı validasyonu (alphanumeric, min 5, max 32 karakter, XSS koruması)
        if (empty($username) || !preg_match('/^[a-zA-Z0-9_]{5,32}$/', $username)) {
            $message = 'Kullanıcı adı en az 5 karakter olmalı ve sadece harf/rakam/altçizgi içermeli.';
        } elseif (!empty($password) && $password !== $password2) {
            $message = 'Şifreler eşleşmiyor.';
        } elseif (!empty($password) && (!preg_match('/^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[^A-Za-z0-9]).{8,}$/', $password))) {
            $message = 'Şifre en az 8 karakter, büyük harf, küçük harf, rakam ve özel karakter içermeli.';
        } else {
            // Sadece admin için güncelle (admin_users tablosu)
            $stmt = $pdo->prepare("UPDATE admin_users SET username = ?" . (!empty($password) ? ", password = ?" : "") . " WHERE username = 'admin'");
            if (!empty($password)) {
                $hashed = password_hash($password, PASSWORD_BCRYPT);
                $result = $stmt->execute([$username, $hashed]);
                // Şifre değiştiyse oturumu sonlandır (brute force koruması)
                session_destroy();
                header('Location: login.php');
                exit;
            } else {
                $result = $stmt->execute([$username]);
            }
            if ($result) {
                $message = 'Bilgiler başarıyla güncellendi.';
            } else {
                $message = 'Güncelleme başarısız.';
            }
        }
    }
    // POST işleminden sonra yeni token üret
    $csrf_token = bin2hex(random_bytes(32));
    $_SESSION['csrf_token'] = $csrf_token;
} else {
    // GET isteği - yeni token üret (eğer yoksa)
    if (!isset($_SESSION['csrf_token'])) {
        $csrf_token = bin2hex(random_bytes(32));
        $_SESSION['csrf_token'] = $csrf_token;
    } else {
        $csrf_token = $_SESSION['csrf_token'];
    }
}

// Mevcut admin bilgilerini çek (admin_users tablosu)
$stmt = $pdo->prepare("SELECT username FROM admin_users WHERE username = 'admin'");
$stmt->execute();
$user = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Profil Ayarları</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <div class="container mt-5">
        <h2>Profil Ayarları (Admin)</h2>
        <?php if ($message): ?>
            <div class="alert alert-info"> <?= htmlspecialchars($message) ?> </div>
        <?php endif; ?>
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf_token) ?>">
            <div class="mb-3">
                <label for="username" class="form-label">Kullanıcı Adı</label>
                <input type="text" class="form-control" id="username" name="username" value="<?= htmlspecialchars($user['username'] ?? 'admin') ?>" required maxlength="32" pattern="^[a-zA-Z0-9_]{5,32}$">
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Yeni Şifre</label>
                <input type="password" class="form-control" id="password" name="password" autocomplete="new-password" minlength="8" pattern="^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[^A-Za-z0-9]).{8,}$">
                <small class="form-text text-muted">En az 8 karakter, büyük harf, küçük harf, rakam ve özel karakter içermeli.</small>
            </div>
            <div class="mb-3">
                <label for="password2" class="form-label">Yeni Şifre (Tekrar)</label>
                <input type="password" class="form-control" id="password2" name="password2" autocomplete="new-password" minlength="8" pattern="^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[^A-Za-z0-9]).{8,}$">
            </div>
            <button type="submit" class="btn btn-primary">Kaydet</button>
        </form>
    </div>
</body>
</html>
