<?php
require_once 'config/config.php';
require_once 'includes/domain_functions.php';

requireLogin();
$type = $_GET['type'] ?? 'all';
$title = 'Tüm Domainler';
$where = '';

switch ($type) {
    case 'expiring':
        $title = 'Süresi Yaklaşan Domainler';
        $where = "WHERE TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) BETWEEN 0 AND 30 AND expiration_date IS NOT NULL";
        break;
    case 'expired':
        $title = 'Süresi Geçmiş Domainler';
        $where = "WHERE TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) < 0 AND expiration_date IS NOT NULL";
        break;
    default:
        $title = 'Tüm Domainler';
        $where = '';
}

$stmt = $pdo->query("SELECT * FROM domains $where ORDER BY expiration_date ASC, domain_name ASC");
$domains = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - <?= $title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><i class="fas fa-list me-2"></i><?= $title ?></h1>
                </div>
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>Domain</th>
                                        <th>Registrar</th>
                                        <th>Kayıt Tarihi</th>
                                        <th>Bitiş Tarihi</th>
                                        <th>Durum</th>
                                        <th>Kalan Gün</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($domains as $domain): ?>
                                        <tr>
                                            <td><strong><?= sanitize($domain['domain_name']) ?></strong></td>
                                            <td><?= sanitize($domain['registrar']) ?: '-' ?></td>
                                            <td><?= formatDate($domain['registration_date']) ?></td>
                                            <td><?= formatDate($domain['expiration_date']) ?></td>
                                            <td>
                                                <?php
                                                $days = null;
                                                if ($domain['expiration_date']) {
                                                    $days = (int)((strtotime($domain['expiration_date']) - strtotime(date('Y-m-d'))) / 86400);
                                                }
                                                if ($days === null) {
                                                    echo '<span class="badge bg-secondary">Bilinmiyor</span>';
                                                } elseif ($days < 0) {
                                                    echo '<span class="badge bg-danger">Süresi Geçmiş</span>';
                                                } elseif ($days <= 7) {
                                                    echo '<span class="badge bg-warning text-dark">Kritik</span>';
                                                } elseif ($days <= 30) {
                                                    echo '<span class="badge bg-info text-dark">Yaklaşıyor</span>';
                                                } else {
                                                    echo '<span class="badge bg-success">Aktif</span>';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <?= $days !== null ? ($days < 0 ? '0' : $days) . ' gün' : '-' ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
