<?php
require_once 'config/config.php';
require_once 'includes/notification_functions.php';

// Giriş kontrolü
requireLogin();

$message = '';
$messageType = '';

// Bildirim yöneticisini başlat
$notificationManager = new NotificationManager($pdo);

// Ayarları kaydet
if ($_POST && isset($_POST['action'])) {
    if ($_POST['action'] === 'save_settings') {
            $smtpSecure = trim($_POST['smtp_secure'] ?? 'tls');
            // Port otomatik belirleme
            $autoPort = 587; // Varsayılan
            if ($smtpSecure === 'ssl') {
                $autoPort = 465;
            } elseif ($smtpSecure === 'tls') {
                $autoPort = 587;
            } elseif ($smtpSecure === 'none') {
                $autoPort = 25;
            }
            
            $settings = [
            'email_notifications_enabled' => isset($_POST['email_notifications_enabled']),
            'notification_email' => trim($_POST['notification_email'] ?? ''),
            'warning_days' => (int)($_POST['warning_days'] ?? 30),
            'critical_days' => (int)($_POST['critical_days'] ?? 7),
            'dashboard_url' => trim($_POST['dashboard_url'] ?? ''),
            'smtp_host' => trim($_POST['smtp_host'] ?? ''),
            'smtp_port' => (int)($_POST['smtp_port'] ?? $autoPort),
            'smtp_username' => trim($_POST['smtp_username'] ?? ''),
            'smtp_password' => trim($_POST['smtp_password'] ?? ''),
            'smtp_secure' => $smtpSecure
        ];
        
        if (empty($settings['notification_email']) || !filter_var($settings['notification_email'], FILTER_VALIDATE_EMAIL)) {
            $message = 'Geçerli bir e-posta adresi girin.';
            $messageType = 'danger';
        } elseif ($settings['warning_days'] < $settings['critical_days']) {
            $message = 'Uyarı günü sayısı kritik günü sayısından küçük olamaz.';
            $messageType = 'danger';
        } else {
            if ($notificationManager->updateNotificationSettings($settings)) {
                $message = 'Bildirim ayarları başarıyla kaydedildi.';
                $messageType = 'success';
            } else {
                $message = 'Ayarlar kaydedilirken hata oluştu.';
                $messageType = 'danger';
            }
        }
    } elseif ($_POST['action'] === 'send_test') {
        $testEmail = trim($_POST['test_email'] ?? '');
        
        if (empty($testEmail) || !filter_var($testEmail, FILTER_VALIDATE_EMAIL)) {
            $message = 'Geçerli bir test e-posta adresi girin.';
            $messageType = 'danger';
        } else {
            $result = $notificationManager->sendTestNotification($testEmail);
            $message = $result;
            $messageType = (strpos($result, 'başarıyla') !== false) ? 'success' : 'danger';
        }
    }
}

// Mevcut ayarları al
$currentSettings = $notificationManager->getNotificationSettings();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - Bildirim Ayarları</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><i class="fas fa-bell me-2"></i>Bildirim Ayarları</h1>
                </div>
                
                <?php if ($message): ?>
                    <div class="alert alert-<?= $messageType ?> alert-dismissible fade show" role="alert">
                        <?= sanitize($message) ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <div class="row">
                    <!-- Bildirim Ayarları -->
                    <div class="col-lg-8">
                        <div class="card shadow">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-cog me-2"></i>E-posta Bildirim Ayarları</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="save_settings">
                                    
                                    <div class="mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="email_notifications_enabled" 
                                                   name="email_notifications_enabled" 
                                                   <?= $currentSettings['email_notifications_enabled'] ? 'checked' : '' ?>>
                                            <label class="form-check-label" for="email_notifications_enabled">
                                                <strong>E-posta bildirimlerini etkinleştir</strong>
                                            </label>
                                        </div>
                                        <small class="form-text text-muted">
                                            Bu seçenek kapalıysa hiçbir e-posta bildirimi gönderilmez.
                                        </small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="notification_email" class="form-label">Bildirim E-posta Adresi *</label>
                                        <input type="email" class="form-control" id="notification_email" name="notification_email" 
                                               value="<?= sanitize($currentSettings['notification_email']) ?>" required>
                                        <small class="form-text text-muted">
                                            Domain süre uyarıları bu e-posta adresine gönderilecek.
                                        </small>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="warning_days" class="form-label">Uyarı Günü Sayısı</label>
                                                <input type="number" class="form-control" id="warning_days" name="warning_days" 
                                                       value="<?= $currentSettings['warning_days'] ?>" min="1" max="365" required>
                                                <small class="form-text text-muted">
                                                    Bu kadar gün kala uyarı bildirimi gönderilir.
                                                </small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="critical_days" class="form-label">Kritik Günü Sayısı</label>
                                                <input type="number" class="form-control" id="critical_days" name="critical_days" 
                                                       value="<?= $currentSettings['critical_days'] ?>" min="1" max="30" required>
                                                <small class="form-text text-muted">
                                                    Bu kadar gün kala kritik bildirim gönderilir.
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="dashboard_url" class="form-label">Dashboard URL'si</label>
                                        <input type="url" class="form-control" id="dashboard_url" name="dashboard_url" 
                                               value="<?= sanitize($currentSettings['dashboard_url']) ?>" 
                                               placeholder="http://localhost/domain-tracker/">
                                        <small class="form-text text-muted">
                                            E-posta bildirimlerindeki "Admin Paneline Git" bağlantısı için kullanılır.
                                        </small>
                                    </div>

                                    <hr>
                                    <h5 class="mb-3">SMTP Ayarları</h5>
                                    <div class="mb-3">
                                        <label for="smtp_host" class="form-label">SMTP Sunucu</label>
                                        <input type="text" class="form-control" id="smtp_host" name="smtp_host" value="<?= sanitize($currentSettings['smtp_host'] ?? '') ?>" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="smtp_port" class="form-label">SMTP Port <small class="text-muted">(Otomatik belirlenir)</small></label>
                                        <input type="number" class="form-control" id="smtp_port" name="smtp_port" value="<?= sanitize($currentSettings['smtp_port'] ?? '587') ?>" placeholder="587" required>
                                        <small class="form-text text-muted">
                                            TLS: 587, SSL: 465, Yok: 25 (Güvenlik seçeneğine göre otomatik güncellenir)
                                        </small>
                                    </div>
                                    <div class="mb-3">
                                        <label for="smtp_username" class="form-label">SMTP Kullanıcı Adı</label>
                                        <input type="text" class="form-control" id="smtp_username" name="smtp_username" value="<?= sanitize($currentSettings['smtp_username'] ?? '') ?>">
                                    </div>
                                    <div class="mb-3">
                                        <label for="smtp_password" class="form-label">SMTP Şifresi</label>
                                        <input type="password" class="form-control" id="smtp_password" name="smtp_password" value="<?= sanitize($currentSettings['smtp_password'] ?? '') ?>">
                                    </div>
                                    <div class="mb-3">
                                        <label for="smtp_secure" class="form-label">SMTP Güvenlik</label>
                                        <select class="form-control" id="smtp_secure" name="smtp_secure">
                                            <option value="tls" <?= ($currentSettings['smtp_secure'] ?? 'tls') === 'tls' ? 'selected' : '' ?>>TLS</option>
                                            <option value="ssl" <?= ($currentSettings['smtp_secure'] ?? '') === 'ssl' ? 'selected' : '' ?>>SSL</option>
                                            <option value="none" <?= ($currentSettings['smtp_secure'] ?? '') === 'none' ? 'selected' : '' ?>>Yok</option>
                                        </select>
                                    </div>
                                    
                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-1"></i>Ayarları Kaydet
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Test ve Bilgi -->
                    <div class="col-lg-4">
                        <!-- Test Bildirimi -->
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h6 class="mb-0"><i class="fas fa-flask me-2"></i>Test Bildirimi</h6>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="send_test">
                                    
                                    <div class="mb-3">
                                        <label for="test_email" class="form-label">Test E-posta Adresi</label>
                                        <input type="email" class="form-control" id="test_email" name="test_email" 
                                               value="<?= sanitize($currentSettings['notification_email']) ?>" required>
                                    </div>
                                    
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-outline-primary">
                                            <i class="fas fa-paper-plane me-1"></i>Test Gönder
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        
                        <!-- Bilgi Kartı -->
                        <div class="card shadow">
                            <div class="card-header">
                                <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Bildirim Sistemi Hakkında</h6>
                            </div>
                            <div class="card-body">
                                <h6>Nasıl Çalışır?</h6>
                                <ul class="list-unstyled">
                                    <li><i class="fas fa-clock me-2 text-primary"></i>Günlük otomatik kontrol</li>
                                    <li><i class="fas fa-envelope me-2 text-primary"></i>E-posta bildirimleri</li>
                                    <li><i class="fas fa-exclamation-triangle me-2 text-warning"></i>Uyarı ve kritik seviyeler</li>
                                    <li><i class="fas fa-history me-2 text-info"></i>Tekrar gönderim kontrolü</li>
                                </ul>
                                
                                <h6 class="mt-3">Cron Job Kurulumu</h6>
                                <p class="small text-muted">
                                    Otomatik kontrol için aşağıdaki cron job'u ekleyin:
                                </p>
                                <?php
                                // Gerçek yolları bul - mutlak yolu kullan
                                $settingsFile = realpath(__FILE__) ?: __FILE__;
                                $projectRoot = dirname($settingsFile);
                                $cronScript = $projectRoot . '/cron/check_expiring_domains.php';
                                
                                // Gerçek mutlak yolu al
                                $realCronPath = realpath($cronScript) ?: $cronScript;
                                ?>
                                <div class="mb-2">
                                    <code class="small d-block p-2 bg-light rounded">
                                        <?php
                                        // PHP yolunu tahmin et (sunucuda çalıştığında gerçek yol olacak)
                                        $phpPath = '/usr/local/bin/php'; // cPanel için varsayılan
                                        if (function_exists('exec')) {
                                            $detectedPhp = @exec('which php 2>/dev/null');
                                            if ($detectedPhp) {
                                                $phpPath = trim($detectedPhp);
                                            }
                                        }
                                        
                                        // Gerçek dosya yolunu kullan
                                        $displayPath = file_exists($realCronPath) ? $realCronPath : $cronScript;
                                        echo htmlspecialchars("0 9 * * * $phpPath $displayPath");
                                        ?>
                                    </code>
                                </div>
                                <div class="small text-muted mb-2">
                                    <strong>Not:</strong> Yukarıdaki yol otomatik olarak belirlenmiştir. 
                                    Sunucunuzda farklıysa, gerçek yolu bulmak için SSH'da şu komutu çalıştırın:
                                </div>
                                <code class="small d-block p-2 bg-light rounded mb-2">
                                    which php
                                </code>
                                <code class="small d-block p-2 bg-light rounded">
                                    pwd
                                </code>
                                <div class="small text-muted mt-2">
                                    <strong>Manuel Kurulum:</strong><br>
                                    1. SSH ile sunucuya bağlanın<br>
                                    2. <code>crontab -e</code> komutunu çalıştırın<br>
                                    3. Yukarıdaki cron job satırını ekleyin<br>
                                    4. Dosyayı kaydedin (vi için: <code>:wq</code>, nano için: <code>Ctrl+X</code>)
                                </div>
                                
                                <h6 class="mt-3">Bildirim Sıklığı</h6>
                                <ul class="small text-muted">
                                    <li><strong>Kritik (≤7 gün):</strong> Günde bir</li>
                                    <li><strong>Uyarı (8-30 gün):</strong> Haftada bir</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/admin.js"></script>
    <script>
        // SMTP Port otomatik belirleme
        document.addEventListener('DOMContentLoaded', function() {
            const smtpSecure = document.getElementById('smtp_secure');
            const smtpPort = document.getElementById('smtp_port');
            
            if (smtpSecure && smtpPort) {
                function updatePort() {
                    const secure = smtpSecure.value.toLowerCase();
                    let port = 587; // Varsayılan
                    
                    switch(secure) {
                        case 'ssl':
                            port = 465;
                            break;
                        case 'tls':
                            port = 587;
                            break;
                        case 'none':
                            port = 25;
                            break;
                    }
                    
                    // Sadece port boşsa veya varsayılan değerse güncelle
                    if (!smtpPort.value || smtpPort.value === '587' || smtpPort.value === '465' || smtpPort.value === '25') {
                        smtpPort.value = port;
                    }
                }
                
                smtpSecure.addEventListener('change', updatePort);
                
                // İlk yüklemede de kontrol et
                updatePort();
            }
        });
    </script>
</body>
</html>

